package devices;

import javax.swing.JFrame;
import javax.swing.JLabel;

import centralSystem.ITicketPrinter;

/**
 * A simple and debug-use only implementation of {@link ITicketPrinter}.
 * This Printer is a JFrame where a label provides queue number any time
 * a client has been added to that queue
 * 
 * @author simone
 *
 */
public class TicketPrinter extends JFrame implements ITicketPrinter{

	private static final long serialVersionUID = 1L;
	private JLabel ticket = new JLabel();

	public TicketPrinter() {
		super("Ticket");
		super.getContentPane().add(ticket);
		super.setVisible(true);
		super.setSize(200, 30);
		//super.setResizable(false);
		super.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	@Override
	/*
	 * (non-Javadoc)
	 * @see centralSystem.ITicketPrinter#printTicket(int)
	 */
	public void printTicket(int totalClient) {
		ticket.setText("    Numero cliente: "+totalClient);
		
	}

}
